/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.internal;

import com.aptana.ide.ui.io.Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public final class SyncPresentationUtils {
    private SyncPresentationUtils() {
    }

    public static String getFileSize(Object element) {
        long rawSize = -1L;
        if (element instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            if (resource != null) {
                rawSize = resource.getLocation().toFile().length();
            } else {
                IFileInfo fileInfo = Utils.getDetailedFileInfo((IAdaptable)((IAdaptable)element));
                if (fileInfo != null) {
                    rawSize = fileInfo.getLength();
                }
            }
        }
        if (rawSize >= 0L) {
            long num;
            long leftover = 0L;
            String string = String.valueOf(Long.toString(rawSize)) + " B";
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " KB";
            }
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " MB";
            }
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " GB";
            }
            if (rawSize > 1024L) {
                leftover = (rawSize /= 1024L) % 1024L;
                num = rawSize;
                if (leftover >= 512L) {
                    ++num;
                }
                string = String.valueOf(num) + " TB";
            }
            return string;
        }
        return "";
    }

    public static String getLastModified(Object element) {
        long timestamp = -1L;
        if (element instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            if (resource != null) {
                timestamp = resource.getLocalTimeStamp();
            } else {
                IFileInfo fileInfo = Utils.getDetailedFileInfo((IAdaptable)((IAdaptable)element));
                if (fileInfo != null) {
                    timestamp = fileInfo.getLastModified();
                }
            }
        }
        if (timestamp >= 0L) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
            return formatter.format(new Date(timestamp));
        }
        return "";
    }
}

